//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "entities.h"

u8 gameOver;
u8 pause;
u16 score;
u8 lives;
Keys keys;
u8 loopMusic;
u8 facingLeft;
i8 enemiesToKill;
u8 bonus;
u8 windows[MAX_WINDOW_ENEMIES];

void createEntity(Entity *entity, u8 entityType, i8 xPos, u8 yPos, u8 height, u8 width, u8 hits, i8 xSpeed, u8 *frame1, u8 *frame2, u8 *frame3, u8 *frame4, u8 *frame5, u8 *frame6, u8 *frame7, u8 *frame8, u8 window){

	entity->state 			= ENEMY_STATE_ACTIVE;
	entity->type			= entityType;
	entity->cycles			= 0;
	entity->bullet			= 255;
	entity->xPos			= xPos;
	entity->yPos			= yPos;
	entity->hits			= hits;
	entity->height			= height;
	entity->width			= width;
	entity->xSpeed			= xSpeed;
	entity->frame1			= frame1;
	entity->frame2			= frame2;
	entity->frame3			= frame3;
	entity->frame4			= frame4;
	entity->frame5			= frame5;
	entity->frame6			= frame6;
	entity->frame7			= frame7;
	entity->frame8			= frame8;
	entity->lastTile		= 100;
	entity->window			= window;

	if(window < 100) windows[window] = TRUE;
}

void addEntity(u8 entityType, i8 xPos, u8 yPos, i8 direction, Entity *enemies, u8 window){

	u8 max = MAX_ENEMIES;
    Entity *enemy = enemies;

    while(max){

        if(enemy->state == ENEMY_STATE_INACTIVE){

        	switch (entityType) {

				case ENEMY_TYPE_BARREL:

					createEntity(enemy, ENEMY_TYPE_BARREL, xPos, yPos, ENEMY_BARREL_H, ENEMY_BARREL_W, 6, ENEMY_BARREL_X_SPEED, G_barril, G_barril, G_barril, G_barril, G_barril, G_barril, G_barril, G_barril, 100);

					break;

				case ENEMY_TYPE_CACTUS:

					createEntity(enemy, ENEMY_TYPE_CACTUS, xPos, yPos, ENEMY_CACTUS_H, ENEMY_CACTUS_W, 5, ENEMY_CACTUS_X_SPEED, G_cactus, G_cactus, G_cactus, G_cactus, G_cactus,  G_cactus, G_cactus, G_cactus, 100);

					break;

				case ENEMY_TYPE_MUROMADERA:

					createEntity(enemy, ENEMY_TYPE_MUROMADERA, xPos, yPos, ENEMY_MUROMADERA_H, ENEMY_MUROMADERA_W, 12, ENEMY_MUROMADERA_X_SPEED, G_muromadera, G_muromadera, G_muromadera, G_muromadera, G_muromadera,  G_muromadera, G_muromadera, G_muromadera, 100);

					break;

				case ENEMY_TYPE_MUROPIEDRA:

					createEntity(enemy, ENEMY_TYPE_MUROPIEDRA, xPos, yPos, ENEMY_MUROPIEDRA_H, ENEMY_MUROPIEDRA_W, 20, ENEMY_MUROPIEDRA_X_SPEED, G_muropiedra, G_muropiedra, G_muropiedra, G_muropiedra, G_muropiedra,  G_muropiedra, G_muropiedra, G_muropiedra, 100);

					break;

				case ENEMY_TYPE_MURO:

					createEntity(enemy, ENEMY_TYPE_MURO, xPos, yPos, ENEMY_MURO_H, ENEMY_MURO_W, 20, ENEMY_MURO_X_SPEED, G_muro, G_muro, G_muro, G_muro, G_muro,  G_muro, G_muro, G_muro, 100);

					break;

				case ENEMY_TYPE_COKE:

					createEntity(enemy, ENEMY_TYPE_COKE, xPos, yPos, ENEMY_COKE_H, ENEMY_COKE_W, 2, ENEMY_COKE_X_SPEED, G_coke, G_coke, G_coke, G_coke, G_coke, G_coke, G_coke, G_coke, 100);

					break;

				case ENEMY_TYPE_MONEY:

					createEntity(enemy, ENEMY_TYPE_MONEY, xPos, yPos, ENEMY_MONEY_H, ENEMY_MONEY_W, 2, ENEMY_MONEY_X_SPEED, G_dolar, G_dolar, G_dolar, G_dolar, G_dolar, G_dolar, G_dolar, G_dolar, 100);

					break;

				case ENEMY_TYPE_BOTTLE:

					createEntity(enemy, ENEMY_TYPE_BOTTLE, xPos, yPos, ENEMY_BOTTLE_H, ENEMY_BOTTLE_W, 1, ENEMY_BOTTLE_X_SPEED, G_botella, G_botella, G_botella, G_botella, G_botella, G_botella, G_botella, G_botella, 100);

					break;

				case ENEMY_TYPE_WINDOW:

					createEntity(enemy, ENEMY_TYPE_WINDOW, xPos, yPos, ENEMY_WINDOW_H, ENEMY_WINDOW_W, 1, ENEMY_WINDOW_X_SPEED, G_malo_ventana1, G_malo_ventana1, G_malo_ventana1, G_malo_ventana1, G_malo_ventana1, G_malo_ventana2, G_malo_ventana_muerte2, G_malo_ventana_muerte2, window);

					break;

				case ENEMY_TYPE_LEJOS:

					createEntity(enemy, ENEMY_TYPE_LEJOS, xPos, yPos, ENEMY_LEJOS_H, ENEMY_LEJOS_W, 1, direction * ENEMY_LEJOS_X_SPEED, G_malo_lejos_drch1, G_malo_lejos_drch2, G_malo_lejos_izq1, G_malo_lejos_izq2, G_malo_lejos_disp1, G_malo_lejos_disp2, G_malo_lejos_muerte1, G_malo_lejos_muerte2, 100);

					break;
				case ENEMY_TYPE_CERCA:

					createEntity(enemy, ENEMY_TYPE_CERCA, xPos, yPos, ENEMY_CERCA_H, ENEMY_CERCA_W, 1, direction * ENEMY_CERCA_X_SPEED, G_malo_cerca_drch1, G_malo_cerca_drch2, G_malo_cerca_izq1, G_malo_cerca_izq2, G_malo_cerca_disp1, G_malo_cerca_disp2, G_malo_cerca_muerte1, G_malo_cerca_muerte2, 100);

					break;
			}

            break;

        }

        enemy++; max--;
    }


}

u8 fire(Bullet *bullets, u8 xPos, u8 yPos, u8 dxPos, u8 isDiagonal){

    u8 x;
    i8 xSpeed = 0;
    Bullet *bullet = bullets;

    if(isDiagonal){
    	if(dxPos > xPos + 10) xSpeed = 2;
    	else if(dxPos < xPos - 10) xSpeed = -2;
    }

    for(x=0;x<MAX_BULLETS;x++){

        if(!bullet->active){

            //Fire sound
        	cpct_akp_SFXPlay(1, 15, 36, 0, 0, AY_CHANNEL_C);

            bullets[x].active = TRUE;
            bullets[x].xPos = xPos;
            bullets[x].yPos = yPos;
            bullets[x].xSpeed = xSpeed;
            bullets[x].ySpeed = 6;
            bullets[x].cycles = 0;

            break;
        }

        bullet++;
    }

    return x;

}


